/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.DeviceEvent;
import com.cisco.pt.ipc.events.DeviceEventListener;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.sim.Device;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceEventRegistry
extends IPCEventRegistry {
    protected Set<DeviceEventListener> globalListeners = new HashSet<DeviceEventListener>();
    protected Map<String, Set<DeviceEventListener>> specificObjectListeners = new HashMap<String, Set<DeviceEventListener>>();
    private static Log logger = LogFactory.getLog(DeviceEventRegistry.class);

    public DeviceEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "Device";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        DeviceEvent evt = null;
        if (eventName.equalsIgnoreCase("nameChanged")) {
            evt = new DeviceEvent.NameChanged(event);
        } else if (eventName.equalsIgnoreCase("powerChanged")) {
            evt = new DeviceEvent.PowerChanged(event);
        } else if (eventName.equalsIgnoreCase("moduleAdded")) {
            evt = new DeviceEvent.ModuleAdded(event);
        } else if (eventName.equalsIgnoreCase("moduleRemoved")) {
            evt = new DeviceEvent.ModuleRemoved(event);
        } else if (eventName.equalsIgnoreCase("portAdded")) {
            evt = new DeviceEvent.PortAdded(event);
        } else if (eventName.equalsIgnoreCase("portRemoved")) {
            evt = new DeviceEvent.PortRemoved(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (DeviceEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<DeviceEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (DeviceEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(DeviceEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("nameChanged");
                this.register("powerChanged");
                this.register("moduleAdded");
                this.register("moduleRemoved");
                this.register("portAdded");
                this.register("portRemoved");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(DeviceEventListener listener, Device objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<DeviceEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<DeviceEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "nameChanged");
                this.register(uuid, "powerChanged");
                this.register(uuid, "moduleAdded");
                this.register(uuid, "moduleRemoved");
                this.register(uuid, "portAdded");
                this.register(uuid, "portRemoved");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(DeviceEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("nameChanged");
                this.deregister("powerChanged");
                this.deregister("moduleAdded");
                this.deregister("moduleRemoved");
                this.deregister("portAdded");
                this.deregister("portRemoved");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(DeviceEventListener listener, Device objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<DeviceEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "nameChanged");
            this.deregister(uuid, "powerChanged");
            this.deregister(uuid, "moduleAdded");
            this.deregister(uuid, "moduleRemoved");
            this.deregister(uuid, "portAdded");
            this.deregister(uuid, "portRemoved");
            specificListeners.remove(listener);
        }
    }

    public void addListener(DeviceEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(DeviceEventListener listener, Device objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(DeviceEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(DeviceEventListener listener, Device objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

